﻿using System;

namespace CustomAttributes
{
    // Tworzenie własnego atrybutu, który ma być przypisywany składowym klasy
    [AttributeUsage(AttributeTargets.Class |
                    AttributeTargets.Constructor |
                    AttributeTargets.Field |
                    AttributeTargets.Method |
                    AttributeTargets.Property,
    AllowMultiple = true)]
    public class BugFixAttribute : System.Attribute
    {
        // Konstruktor atrybutu dla parametrów pozycyjnych
        public BugFixAttribute
        (
            int bugID,
            string programmer,
            string date
        )
        {
            this.BugID = bugID;
            this.Programmer = programmer;
            this.Date = date;
        }

        // Akcesory
        public int BugID { get; private set; }
        public string Date { get; private set; }
        public string Programmer { get; private set; }

        // Właściwość dla parametru nazwanego
        public string Comment { get; set; }
    }

    // ********* Przypisywanie atrybutów do klasy ********

    [BugFixAttribute(121, "Roman Herman", "01-03-08")]
    [BugFixAttribute(107, "Roman Herman", "01-04-08",
                        Comment = "Poprawiony błąd przesunięcia")]
    public class MyMath
    {
        public double DoFunc1(double param1)
        {
            return param1 + DoFunc2(param1);
        }

        public double DoFunc2(double param1)
        {
            return param1 / 3;
        }
    }
    public class Tester
    {
        // Listing 17-2. Korzystanie z odzwierciedlania
        public static void Main(string[] args)
        {
            MyMath mm = new MyMath();
            Console.WriteLine("Wywołanie DoFunc(7). Wynik: {0}",
                              mm.DoFunc1(7));

            // Pobranie informacji na temat składowej
            // i użycie jej do wydobycia własnych atrybutów
            System.Reflection.MemberInfo inf = typeof(MyMath);
            object[] attributes;
            attributes = inf.GetCustomAttributes(
                             typeof(BugFixAttribute), false);

            // Przejście przez atrybuty z wydobywaniem właściwości
            foreach (Object attribute in attributes)
            {
                BugFixAttribute bfa = (BugFixAttribute)attribute;
                Console.WriteLine("\nIdentyfikator błędu: {0}", bfa.BugID);
                Console.WriteLine("Programista: {0}", bfa.Programmer);
                Console.WriteLine("Data: {0}", bfa.Date);
                Console.WriteLine("Komentarz: {0}", bfa.Comment);
            }
        }
    }
}